/*
 * Decompiled with CFR 0.152.
 */
package chatnow.ui;

import chatnow.Timer;
import chatnow.TimerListener;
import chatnow.ui.CodedTextUtilities;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import netscape.security.PrivilegeManager;

public class CustomTextField
extends Canvas
implements ClipboardOwner,
MouseListener,
MouseMotionListener,
KeyListener,
FocusListener,
TimerListener {
    private String c2 = "";
    private int cs = -1;
    private boolean cv = false;
    private boolean cr = false;
    private Color cu = Color.white;
    private Color de = Color.black;
    private boolean c0 = true;
    private boolean c7 = true;
    private int cm = 0;
    private char cz = '\u0000';
    private int c8 = 0;
    private int c6 = 0;
    private int co = 0;
    private boolean dd = true;
    private boolean cw = true;
    private Rectangle da;
    private static Clipboard cx = null;
    private int c4 = -1;
    private long cy = 0L;
    private boolean dc = false;
    private Font c3;
    private Font cn;
    private FontMetrics cq;
    private FontMetrics c5;
    private Image cp;
    private Image db = null;
    private Graphics c1 = null;
    private Timer ct;
    private boolean c9 = false;
    protected transient TextListener textListener = null;
    protected ActionListener actionListener = null;

    public CustomTextField() {
        if (cx == null) {
            try {
                Class.forName("netscape.security.PrivilegeManager");
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalSystemClipboardAccess");
                    cx = this.getToolkit().getSystemClipboard();
                }
                catch (Exception exception) {
                    cx = new Clipboard("ICM");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                cx = new Clipboard("ICM");
            }
        }
        this.c3 = CodedTextUtilities.getFont("sanserif", 0, 12);
        this.cq = this.getFontMetrics(this.c3);
        this.cn = CodedTextUtilities.getFont(this.c3.getFamily(), this.c3.getStyle() | 1, this.c3.getSize());
        this.c5 = this.getFontMetrics(this.cn);
        this.setCursor(new Cursor(2));
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.ct = new Timer(500L, this);
        this.ct.start();
    }

    public CustomTextField(int n) {
        this();
    }

    public CustomTextField(String string) {
        this();
        this.setText(string);
        this.repaint();
    }

    public CustomTextField(String string, int n) {
        this();
        this.setText(string);
        this.repaint();
    }

    public void ring() {
        this.c9 = !this.c9;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n = 2;
        int n2 = 2;
        int n3 = this.getSize().width - 1;
        int n4 = this.getSize().height - 1;
        Color color = this.de;
        if (color != null) {
            String string;
            int n5;
            if (this.echoCharIsSet()) {
                StringBuffer stringBuffer = new StringBuffer(this.c2.length());
                for (n5 = 0; n5 < this.c2.length(); ++n5) {
                    stringBuffer = stringBuffer.append(this.cz);
                }
                string = stringBuffer.toString();
            } else {
                string = this.c2;
            }
            int n6 = this.cq.getHeight();
            n5 = this.getSize().width - 3;
            int n7 = CodedTextUtilities.stringWidth(string, this.c3, this.cq, this.cn, this.c5, false);
            int n8 = CodedTextUtilities.stringWidth(string.substring(0, this.c8), this.c3, this.cq, this.cn, this.c5, false);
            if (n5 <= 0 || n7 + 2 < n5) {
                this.cm = 0;
            } else {
                int n9 = this.cm + n8;
                while (n9 < 0) {
                    this.cm += n5 / 5;
                    if (this.cm > 0) {
                        this.cm = 0;
                    }
                    n9 = this.cm + n8;
                }
                while (n9 > n5) {
                    this.cm -= n5 / 5;
                    if (this.cm < n5 - n7 - 1) {
                        this.cm = n5 - n7 - 1;
                    }
                    n9 = this.cm + n8;
                }
            }
            n += this.cm;
            if (this.db == null) {
                this.db = this.createImage(this.getSize().width, this.getSize().height);
                this.c1 = this.db.getGraphics();
                this.c1.setFont(this.c3);
            }
            this.c1.setColor(this.cu);
            this.c1.fillRect(0, 0, this.getSize().width, this.getSize().height);
            if (this.cp != null) {
                this.c1.drawImage(this.cp, 0, 0, this);
            }
            if (this.cw) {
                this.a(this.c1, n3, n4);
            }
            Graphics graphics2 = this.c1.create();
            graphics2.setClip(2, 2, n3 - 3, n4 - 3);
            graphics2.setFont(this.c3);
            CodedTextUtilities.renderText(graphics2, string, n6, this.c3, this.cq, this.cn, this.c5, n + 1, 2, color, this.getBackground());
            this.da = null;
            this.a(graphics2, n + 1, n2, string);
            if (this.cr && this.dd) {
                int n10 = n + 1 + n8;
                graphics2.setColor(color);
                if (!this.c9) {
                    graphics2.drawLine(n10, n2, n10, n2 + this.cq.getHeight() - 1);
                }
                if (this.da == null) {
                    this.da = new Rectangle(n10, n2, 1, n6);
                }
            }
            graphics.drawImage(this.db, 0, 0, this);
        }
    }

    private void a(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.gray);
        graphics.drawLine(0, 0, n, 0);
        graphics.drawLine(0, 0, 0, n2);
        graphics.setColor(Color.black);
        graphics.drawLine(1, 1, n, 1);
        graphics.drawLine(1, 1, 1, n2);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n - 1, 1, n - 1, n2 - 1);
        graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
        graphics.setColor(Color.white);
        graphics.drawLine(n, 0, n, n2);
        graphics.drawLine(0, n2, n, n2);
    }

    private void a(Graphics graphics, int n, int n2, String string) {
        if (this.c6 < this.co) {
            int n3 = n + CodedTextUtilities.stringWidth(string.substring(0, this.c6), this.c3, this.cq, this.cn, this.c5, false);
            int n4 = n + CodedTextUtilities.stringWidth(string.substring(0, this.co), this.c3, this.cq, this.cn, this.c5, false);
            this.da = new Rectangle(n3 + this.cm, n2, n4 - n3, this.cq.getHeight());
            graphics.setXORMode(this.getBackground());
            graphics.fillRect(this.da.x, this.da.y, this.da.width, this.da.height);
            graphics.setPaintMode();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setEnabled(boolean bl) {
        this.c0 = bl;
        if (this.c0) {
            this.de = Color.black;
            this.setCursor(new Cursor(2));
        } else {
            this.de = Color.lightGray.darker();
            this.setCursor(new Cursor(0));
        }
        this.repaint();
    }

    public boolean isEnabled() {
        return this.c0;
    }

    public void setEditable(boolean bl) {
        this.c7 = bl;
        this.cu = this.c7 ? Color.white : Color.lightGray;
        this.repaint();
    }

    public boolean isEditable() {
        return this.c7;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.c3 = font;
        this.cq = this.getFontMetrics(this.c3);
        this.cn = CodedTextUtilities.getFont(this.c3.getFamily(), this.c3.getStyle() | 1, this.c3.getSize());
        this.c5 = this.getFontMetrics(this.cn);
        if (this.c1 != null) {
            this.c1.setFont(this.c3);
        }
        this.repaint();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 > 0 && n4 > 0) {
            this.db = this.createImage(n3, n4);
            this.c1 = this.db.getGraphics();
            this.c1.setFont(this.c3);
        }
        super.setBounds(n, n2, n3, n4);
        this.repaint();
    }

    public void setShowBevel(boolean bl) {
        this.cw = bl;
        this.repaint();
    }

    public void setBackgroundImage(Image image) {
        this.cp = image;
        this.repaint();
    }

    public void setText(String string) {
        this.c2 = this.cs < 0 ? new String(string) : (string.length() > this.cs ? new String(string.substring(0, this.cs)) : new String(string));
        this.select(0, 0);
    }

    public boolean echoCharIsSet() {
        return this.cz > '\u0000';
    }

    public char getEchoChar() {
        return this.cz;
    }

    public void setEchoChar(char c) {
        this.cz = c;
        this.repaint();
    }

    public int getCaretPosition() {
        return this.c8;
    }

    public void setCaretPosition(int n) {
        if (n != this.c8) {
            this.c8 = n;
            this.repaint();
        }
    }

    public int getSelectionStart() {
        return this.c6;
    }

    public void setSelectionStart(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > this.c2.length()) {
            n = this.c2.length();
        }
        this.c6 = n;
        this.c8 = n;
        this.repaint();
    }

    public int getSelectionEnd() {
        return this.co;
    }

    public void setSelectionEnd(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > this.c2.length()) {
            n = this.c2.length();
        }
        this.co = n;
        this.c8 = n;
        this.repaint();
    }

    public int getTextLength() {
        return this.c2.length();
    }

    public String getText() {
        return this.c2.toString();
    }

    public String toString() {
        return this.c2.toString();
    }

    public void setLength(int n) {
        if (n >= 0) {
            this.cs = n;
            this.setText(this.c2);
        } else {
            this.cs = -1;
        }
    }

    public int getLength() {
        return this.cs;
    }

    public boolean isFocusable() {
        return true;
    }

    public void sendChanged() {
        if (this.textListener != null) {
            this.textListener.textValueChanged(new TextEvent(this, 900));
        }
    }

    public void setNumericOnly(boolean bl) {
        this.cv = bl;
    }

    public boolean isNumericOnly() {
        return this.cv;
    }

    public void focusLost(FocusEvent focusEvent) {
        this.cr = false;
        this.dd = false;
        this.repaint();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.cr = true;
        if (this.c0) {
            this.dd = true;
        }
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        this.dc = true;
        this.requestFocus();
        this.cr = true;
        if (!this.c0) {
            return;
        }
        this.dd = true;
        this.c4 = n = this.findTextPos(mouseEvent.getX());
        if (n >= 0) {
            if (mouseEvent.isShiftDown()) {
                this.selectFromCursor(n);
            } else {
                long l = mouseEvent.getWhen();
                if (l - this.cy < 300L) {
                    String string = this.c2;
                    if (n < 0) {
                        n = 0;
                    } else if (n == string.length()) {
                        --n;
                    }
                    while (n >= 0 && string.charAt(n) == ' ') {
                        --n;
                    }
                    while (n >= 0 && string.charAt(n) != ' ') {
                        --n;
                    }
                    int n2 = ++n;
                    while (n < string.length() && string.charAt(n) != ' ') {
                        ++n;
                    }
                    while (n < string.length() && string.charAt(n) == ' ') {
                        ++n;
                    }
                    this.select(n2, n);
                } else {
                    this.select(n);
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.c0) {
            mouseEvent.consume();
            this.dc = false;
            this.cy = mouseEvent.getWhen();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.c0) {
            int n = this.findTextPos(mouseEvent.getX());
            if (n >= 0 && n != this.c4) {
                this.selectFromCursor(n);
            }
            this.c4 = n;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!this.c0) {
            return;
        }
        if (!this.c7) {
            switch (keyEvent.getKeyCode()) {
                case 36: {
                    this.moveTo(0, keyEvent.isShiftDown());
                    break;
                }
                case 35: {
                    this.moveTo(this.c2.length(), keyEvent.isShiftDown());
                    break;
                }
                case 37: {
                    this.moveLeft(keyEvent.isControlDown(), keyEvent.isShiftDown());
                    break;
                }
                case 39: {
                    this.moveRight(keyEvent.isControlDown(), keyEvent.isShiftDown());
                }
            }
            return;
        }
        if (keyEvent.isControlDown()) {
            switch (keyEvent.getKeyCode()) {
                case 66: {
                    return;
                }
                case 69: {
                    return;
                }
                case 82: {
                    return;
                }
                case 85: {
                    return;
                }
                case 79: {
                    return;
                }
                case 75: {
                    return;
                }
            }
        }
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 155) {
            this.copy();
            return;
        }
        if (keyEvent.isShiftDown() && keyEvent.getKeyCode() == 155) {
            this.paste();
            return;
        }
        if (keyEvent.isShiftDown() && keyEvent.getKeyCode() == 127) {
            this.cut();
            return;
        }
        if (keyEvent.isControlDown() || keyEvent.isMetaDown()) {
            switch (keyEvent.getKeyCode()) {
                case 67: {
                    this.copy();
                    return;
                }
                case 86: {
                    this.paste();
                    this.sendChanged();
                    return;
                }
                case 88: {
                    this.cut();
                    this.sendChanged();
                    return;
                }
                case 90: {
                    return;
                }
            }
        }
        switch (keyEvent.getKeyCode()) {
            case 36: {
                this.moveTo(0, keyEvent.isShiftDown());
                break;
            }
            case 35: {
                this.moveTo(this.c2.length(), keyEvent.isShiftDown());
                break;
            }
            case 37: {
                this.moveLeft(keyEvent.isControlDown(), keyEvent.isShiftDown());
                break;
            }
            case 39: {
                this.moveRight(keyEvent.isControlDown(), keyEvent.isShiftDown());
                break;
            }
            case 8: {
                this.doBackspaceKey();
                keyEvent.consume();
                this.sendChanged();
                break;
            }
            case 127: {
                this.doDeleteKey();
                keyEvent.consume();
                this.sendChanged();
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            case 9: {
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                break;
            }
            case 38: {
                break;
            }
            case 40: {
                break;
            }
            case 10: {
                ActionEvent actionEvent = new ActionEvent(this, 0, this.getText());
                if (this.actionListener == null) break;
                this.actionListener.actionPerformed(actionEvent);
                break;
            }
            case 155: {
                break;
            }
            case 27: {
                break;
            }
            case 112: {
                break;
            }
            case 113: {
                break;
            }
            case 114: {
                break;
            }
            case 115: {
                break;
            }
            case 116: {
                break;
            }
            case 117: {
                break;
            }
            case 118: {
                break;
            }
            case 119: {
                break;
            }
            case 120: {
                break;
            }
            case 121: {
                break;
            }
            case 122: {
                break;
            }
            case 123: {
                break;
            }
            case 144: {
                break;
            }
            case 19: {
                break;
            }
            case 154: {
                break;
            }
            case 145: {
                break;
            }
            case 20: {
                break;
            }
            default: {
                if (this.cv) {
                    char c = keyEvent.getKeyChar();
                    if (c < '0' || c > '9') break;
                    this.deleteSelection();
                    this.insertChar(keyEvent.getKeyChar());
                    this.select(this.c8 + 1);
                    break;
                }
                this.deleteSelection();
                this.insertChar(keyEvent.getKeyChar());
                this.select(this.c8 + 1);
            }
        }
    }

    protected int findTextPos(int n) {
        int n2;
        int n3;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if ((n -= this.cm) < 0) {
            return 0;
        }
        String string = this.c2;
        int n4 = 0;
        for (n3 = 0; n3 < string.length() && n >= (n2 = fontMetrics.stringWidth(string.substring(0, n3 + 1))) - (n2 - n4) / 2; ++n3) {
            n4 = n2;
        }
        return n3;
    }

    public void insertText(String string, int n) {
        if (this.c2.length() + string.length() > this.cs && this.cs > -1) {
            Toolkit.getDefaultToolkit().beep();
            string = string.substring(0, this.cs - this.c2.length());
        }
        String string2 = this.c2.substring(0, n);
        if (n < 0) {
            n = Math.max(0, this.c2.length() - (n + 1));
        }
        string2 = string2.concat(string);
        this.c2 = string2 = string2.concat(this.c2.substring(n));
        this.sendChanged();
    }

    public void insertChar(char c) {
        if (this.c2.length() + 1 > this.cs && this.cs > -1) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        String string = this.c2.substring(0, this.c8);
        string = string.concat(String.valueOf(c));
        this.c2 = string = string.concat(this.c2.substring(this.c8));
        this.sendChanged();
    }

    public void select(int n, int n2) {
        if (n < 0) {
            n = 0;
        } else if (n > this.c2.length()) {
            n = this.c2.length();
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this.c2.length()) {
            n2 = this.c2.length();
        }
        if (n > n2) {
            this.c6 = n2;
            this.co = n;
        } else {
            this.c6 = n;
            this.co = n2;
        }
        this.c8 = n2;
        this.repaint();
    }

    public void select(int n) {
        this.select(n, n);
    }

    public void selectAll() {
        this.select(0, this.c2.length());
    }

    protected void deleteSelection() {
        if (this.c6 < this.co) {
            String string = this.c2;
            this.c2 = new String("");
            if (this.c6 > 0) {
                this.c2 = this.c2.concat(string.substring(0, this.c6));
            }
            if (this.co < string.length()) {
                this.c2 = this.c2.concat(string.substring(this.co, string.length()));
            }
            this.co = this.c6;
            this.c8 = this.c6;
            this.repaint();
        }
    }

    protected void doBackspaceKey() {
        if (this.c6 == this.co && this.c6 > 0) {
            --this.c6;
        }
        this.deleteSelection();
    }

    protected void doDeleteKey() {
        if (this.c6 == this.co && this.co < this.c2.length()) {
            ++this.co;
        }
        this.deleteSelection();
    }

    protected void moveTo(int n, boolean bl) {
        if (n >= 0) {
            if (bl) {
                if (this.c8 == this.c6) {
                    this.select(this.co, n);
                } else {
                    this.select(this.c6, n);
                }
            } else {
                this.select(n);
            }
        }
    }

    protected void moveLeft(boolean bl, boolean bl2) {
        int n = -1;
        if (!bl) {
            n = this.c8 - 1;
        } else {
            n = this.c8;
            String string = this.c2;
            if (n == string.length() || string.charAt(n) != ' ') {
                --n;
            }
            while (n >= 0 && string.charAt(n) == ' ') {
                --n;
            }
            while (n >= 0 && string.charAt(n) != ' ') {
                --n;
            }
            if (n >= 0 && string.charAt(n) == ' ') {
                ++n;
            }
        }
        if (n < 0) {
            n = 0;
        }
        this.moveTo(n, bl2);
    }

    protected void moveRight(boolean bl, boolean bl2) {
        int n = -1;
        if (!bl) {
            n = this.c8 + 1;
        } else {
            String string = this.c2;
            for (n = this.c8; n < string.length() && string.charAt(n) == ' '; ++n) {
            }
            while (n < string.length() && string.charAt(n) != ' ') {
                ++n;
            }
            while (n < string.length() && string.charAt(n) == ' ') {
                ++n;
            }
        }
        if (n > this.c2.length()) {
            n = this.c2.length();
        }
        this.moveTo(n, bl2);
    }

    protected void cut() {
        StringSelection stringSelection = new StringSelection(this.getSelectedText());
        cx.setContents(stringSelection, this);
        this.deleteSelection();
        this.repaint();
    }

    protected void copy() {
        StringSelection stringSelection = new StringSelection(this.getSelectedText());
        cx.setContents(stringSelection, this);
    }

    protected void paste() {
        Transferable transferable = cx.getContents(this);
        if (transferable != null) {
            String string;
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                return;
            }
            this.deleteSelection();
            this.insertText(string, this.c8);
            this.select(this.c6 + string.length());
        }
    }

    public String getSelectedText() {
        return this.c2.substring(this.c6, this.co);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    protected void selectFromCursor(int n) {
        if (this.c8 == this.c6) {
            this.select(this.co, n);
        } else {
            this.select(this.c6, n);
        }
    }

    public synchronized void addTextListener(TextListener textListener) {
        this.textListener = AWTEventMulticaster.add(this.textListener, textListener);
    }

    public synchronized void removeTextListener(TextListener textListener) {
        this.textListener = AWTEventMulticaster.remove(this.textListener, textListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }
}

